/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.model.events.SelectedNodesAndEdgesListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListMultipleSelection;
import org.json.simple.JSONObject;
import org.nrnb.gsoc.enrichment.RequestEngine.HTTPRequestEngine;
import org.nrnb.gsoc.enrichment.RequestEngine.ScheduledRequestEngine;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;
import org.nrnb.gsoc.enrichment.tasks.OrganismAndGeneIdAssertionTask;
import org.nrnb.gsoc.enrichment.ui.EnrichmentCytoPanel;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;

public class EnrichmentTask
extends AbstractTask
implements ObservableTask {
    final CyServiceRegistrar registrar;
    final CyApplicationManager applicationManager;
    final CyNetwork network;
    private boolean noSignificant = false;
    final CyNetworkView networkView;
    private static int MAX_NUMBER_OF_NODES = 2000;
    private boolean isLargeNetwork;
    public CyTable enrichmentTable = null;
    EnrichmentCytoPanel enrichmentPanel = null;
    private boolean show = true;
    Long res;
    private final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    @Tunable(description="Organism", context="nogui", required=true, longDescription="The organism associated with the query genes, e.g,. hsapiens. List of possible ID-s can be seen at https://biit.cs.ut.ee/gprofiler/page/organism-list", exampleStringValue="hsapiens")
    public String organism;
    @Tunable(description="Gene ID Column", context="nogui", required=true, longDescription="The Node Table column containing the gene symbols or identifiers to be queried.", exampleStringValue="name")
    public String geneID;
    @Tunable(description="Adjusted p-value threshold", context="nogui", longDescription="A float value between 0 and 1, used to define a significance threshold for filtering returned results. Default is 0.05.", exampleStringValue="0.05")
    public String user_threshold;
    @Tunable(description="Include inferred GO annotations (IEA)", context="nogui", longDescription="The default is false. If true, g:GOSt excludes electronic annotations from GO terms.", exampleStringValue="false")
    public String no_iea;
    @Tunable(description="Multiple testing correction", context="nogui", longDescription="The following multiple testing correction methods are supported: g_SCS (default), bonferroni and fdr.", exampleStringValue="g_SCS")
    public String significance_threshold_method;
    public ListMultipleSelection<CyNode> nodesToFilterBy;
    final Map<String, String> colSourceMap;
    final Map<String, Long> enrichmentNodesMap;

    public EnrichmentTask(CyServiceRegistrar registrar, CytoPanelComponent2 enrichmentPanel) {
        this.registrar = registrar;
        this.applicationManager = (CyApplicationManager)registrar.getService(CyApplicationManager.class);
        this.network = this.applicationManager.getCurrentNetwork();
        this.networkView = this.applicationManager.getCurrentNetworkView();
        this.nodesToFilterBy = new ListMultipleSelection(this.network.getNodeList());
        this.nodesToFilterBy.setSelectedValues(CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true));
        this.isLargeNetwork = false;
        this.enrichmentNodesMap = new HashMap<String, Long>();
        this.enrichmentPanel = (EnrichmentCytoPanel)enrichmentPanel;
        this.colSourceMap = new HashMap<String, String>(){
            {
                this.put("GO:MF", "Gene Ontology Molecular Function");
                this.put("GO:BP", "Gene Ontology Biological Process");
                this.put("GO:CC", "Gene Ontology Cellular Component branch");
                this.put("KEGG", "KEGG");
                this.put("WP", "WikiPathways");
                this.put("REAC", "Reactome pathways");
                this.put("TF", "Transfac transcription factor binding site predictions");
                this.put("MIRNA", "mirTarBase miRNA targets");
                this.put("HPA", "Human Protein Atlas");
                this.put("CORUM", " Manually annotated protein complexes from mammalian organisms");
                this.put("HP", "Human Phenotype Ontology");
            }
        };
    }

    public EnrichmentTask(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.applicationManager = (CyApplicationManager)registrar.getService(CyApplicationManager.class);
        this.network = this.applicationManager.getCurrentNetwork();
        this.networkView = this.applicationManager.getCurrentNetworkView();
        this.nodesToFilterBy = new ListMultipleSelection(this.network.getNodeList());
        this.nodesToFilterBy.setSelectedValues(CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true));
        this.isLargeNetwork = false;
        this.enrichmentNodesMap = new HashMap<String, Long>();
        this.colSourceMap = new HashMap<String, String>(){
            {
                this.put("GO:MF", "GO:Molecular Function");
                this.put("GO:BP", "GO:Biological Process");
                this.put("GO:CC", "GO:Cellular Component");
                this.put("KEGG", "KEGG");
                this.put("WP", "WikiPathways");
                this.put("REAC", "Reactome");
                this.put("TF", "Transfac");
                this.put("MIRNA", "mirTarBase");
                this.put("HPA", "Human Protein Atlas");
                this.put("CORUM", "CORUM");
                this.put("HP", "Human Phenotype Ontology");
            }
        };
    }

    public void run(TaskMonitor monitor) {
        int compIndex;
        Component panel;
        String canonicalName;
        HashSet<String> nodeNameList = new HashSet<String>();
        ArrayList<Long> nodesToFilter = new ArrayList<Long>();
        List nodeList = this.nodesToFilterBy.getSelectedValues();
        monitor.setTitle("gProfiler Enrichment Analysis");
        this.logger.info((Object)"Enrichment Task Started");
        if (nodeList.size() > 0) {
            for (CyNode node : nodeList) {
                nodesToFilter.add(node.getSUID());
                canonicalName = ModelUtils.getNetGeneIDColumn(this.network) == null ? (String)this.network.getDefaultNodeTable().getRow((Object)node.getSUID()).get("name", String.class) : (String)this.network.getDefaultNodeTable().getRow((Object)node.getSUID()).get(ModelUtils.getNetGeneIDColumn(this.network), String.class);
                nodeNameList.add(canonicalName);
                this.enrichmentNodesMap.put(canonicalName, node.getSUID());
            }
        } else {
            nodeList = this.network.getNodeList();
            for (CyNode node : nodeList) {
                nodesToFilter.add(node.getSUID());
                if (this.geneID != null) {
                    ModelUtils.setNetGeneIDColumn(this.network, this.geneID);
                    canonicalName = (String)this.network.getDefaultNodeTable().getRow((Object)node.getSUID()).get(this.geneID, String.class);
                } else if (ModelUtils.getNetGeneIDColumn(this.network) == null) {
                    canonicalName = (String)this.network.getDefaultNodeTable().getRow((Object)node.getSUID()).get("name", String.class);
                    this.geneID = OrganismAndGeneIdAssertionTask.getGeneIdPrediction();
                } else {
                    canonicalName = (String)this.network.getDefaultNodeTable().getRow((Object)node.getSUID()).get(ModelUtils.getNetGeneIDColumn(this.network), String.class);
                    this.geneID = ModelUtils.getNetGeneIDColumn(this.network);
                }
                if (canonicalName == null || canonicalName.length() <= 0) continue;
                nodeNameList.add(canonicalName);
                this.enrichmentNodesMap.put(canonicalName, node.getSUID());
            }
        }
        if (nodeNameList.isEmpty()) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Task cannot be performed. No nodes selected for enrichment.");
            this.noSignificant = true;
        }
        if (nodeNameList.size() > MAX_NUMBER_OF_NODES) {
            this.isLargeNetwork = true;
            monitor.setStatusMessage("Cannot run query as size of query is too large");
            monitor.setProgress(1.0);
            return;
        }
        StringBuffer query = new StringBuffer("");
        Iterator setIterator = nodeNameList.iterator();
        while (setIterator.hasNext()) {
            query.append((String)setIterator.next());
            if (!setIterator.hasNext()) continue;
            query.append(" ");
        }
        Map<String, Object> parameters = this.generateQuery(query.toString());
        HTTPRequestEngine requestEngine = new HTTPRequestEngine();
        if (this.geneID == null) {
            this.logger.warn((Object)"No Gene ID selected. name selected as default.");
        }
        this.logger.info((Object)("Sending request to GProfiler for enrichment. Parameters set are: Organism: " + (this.organism == null ? "hsapiens" : this.organism) + ", Gene ID: " + (this.geneID == null ? OrganismAndGeneIdAssertionTask.getGeneIdPrediction() : this.geneID)));
        JSONObject result = requestEngine.makePostRequest(this.network, "gost/profile/", parameters, monitor, nodeList.isEmpty());
        StringBuffer responseBuffer = new StringBuffer("");
        CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        CyTableFactory tableFactory = (CyTableFactory)this.registrar.getService(CyTableFactory.class);
        CyTableManager tableManager = (CyTableManager)this.registrar.getService(CyTableManager.class);
        this.enrichmentTable = tableFactory.createTable(EnrichmentTerm.TermSource.ALL.getTable(), "id", Long.class, false, true);
        this.enrichmentTable.setSavePolicy(SavePolicy.SESSION_FILE);
        tableManager.addTable(this.enrichmentTable);
        if (result == null) {
            this.res = null;
            monitor.showMessage(TaskMonitor.Level.ERROR, "Enrichment retrieval returned no results, possibly due to an error.");
            monitor.setStatusMessage("Enrichment retrieval returned no results, due to invalid Query Parameters");
            this.noSignificant = true;
            if (this.enrichmentPanel == null) {
                this.enrichmentPanel = new EnrichmentCytoPanel(this.registrar, this.noSignificant, result);
            } else {
                this.enrichmentPanel.initPanel(true);
            }
            monitor.setProgress(1.0);
            return;
        }
        this.res = this.enrichmentTable.getSUID();
        responseBuffer.append(result.get((Object)"result").toString());
        if (responseBuffer.toString().length() == 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Enrichment retrieval returned no valid results, possibly due to an invalid query request.");
            this.noSignificant = true;
            if (this.enrichmentPanel == null) {
                this.enrichmentPanel = new EnrichmentCytoPanel(this.registrar, this.noSignificant, result);
            } else {
                this.enrichmentPanel.initPanel(true);
            }
            monitor.setProgress(1.0);
            return;
        }
        ModelUtils.deleteEnrichmentTables(this.registrar, this.network);
        ModelUtils.setupEnrichmentTable(this.enrichmentTable);
        ArrayList<String> nodeNames = new ArrayList<String>(nodeNameList);
        List<EnrichmentTerm> processTerms = ModelUtils.getEnrichmentfromJSON(result, this.network, nodeNames, this.enrichmentNodesMap);
        if (processTerms == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Enrichment retrieval returned no valid results, possibly due to an invalid query request.");
            return;
        }
        if (processTerms.size() == 0) {
            CyRow row = this.enrichmentTable.getRow((Object)0L);
            row.set("network.SUID", (Object)this.network.getSUID());
        }
        for (int i = 0; i < processTerms.size(); ++i) {
            EnrichmentTerm term = processTerms.get(i);
            CyRow row = this.enrichmentTable.getRow((Object)i);
            if (this.colSourceMap.containsKey(term.getSource())) {
                row.set("source", (Object)this.colSourceMap.get(term.getSource()));
            } else {
                row.set("source", (Object)term.getSource());
            }
            row.set("term id", (Object)term.getTermID());
            row.set("term name", (Object)term.getName());
            row.set("description", (Object)term.getDescription());
            row.set("p-value", (Object)term.getPValue());
            row.set("query size", (Object)term.getQuerySize());
            row.set("background size", (Object)term.getEffectiveDomainSize());
            row.set("term size", (Object)term.getTermSize());
            row.set("intersection size", (Object)term.getIntersectionSize());
            row.set("precision", (Object)term.getPrecision());
            row.set("recall", (Object)term.getRecall());
            row.set("intersecting genes", term.getGenes());
            row.set("nodes.SUID", term.getNodesSUID());
            row.set("network.SUID", (Object)this.network.getSUID());
            row.set("Evidence codes", term.getEvidenceCodes());
            row.set("chart color", (Object)"");
        }
        CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        if (cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment") >= 0 && (panel = cytoPanel.getComponentAt(compIndex = cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"))) instanceof CytoPanelComponent2) {
            this.registrar.unregisterService((Object)panel, CytoPanelComponent.class);
            this.registrar.unregisterService((Object)panel, SelectedNodesAndEdgesListener.class);
            this.registrar.unregisterService((Object)panel, SetCurrentNetworkListener.class);
        }
        if (this.show) {
            this.enrichmentPanel.setEnrichmentTable(this.enrichmentTable);
            this.registrar.registerService((Object)this.enrichmentPanel, CytoPanelComponent.class, new Properties());
            this.registrar.registerService((Object)this.enrichmentPanel, SelectedNodesAndEdgesListener.class, new Properties());
            this.registrar.registerService((Object)this.enrichmentPanel, SetCurrentNetworkListener.class, new Properties());
            if (cytoPanel.getState() == CytoPanelState.HIDE) {
                cytoPanel.setState(CytoPanelState.DOCK);
            }
            cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
            this.enrichmentPanel.setEnrichmentTable(this.enrichmentTable);
        }
        monitor.setProgress(1.0);
    }

    private Map<String, Object> generateQuery(String query) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.organism != null) {
            parameters.put("organism", this.organism);
            ModelUtils.setNetOrganism(this.network, this.organism);
        } else if (ModelUtils.getNetOrganism(this.network) != null) {
            parameters.put("organism", ModelUtils.getNetOrganism(this.network));
            this.organism = ModelUtils.getNetOrganism(this.network);
        } else {
            parameters.put("organism", OrganismAndGeneIdAssertionTask.getOrganismPrediction());
            this.organism = OrganismAndGeneIdAssertionTask.getOrganismPrediction();
        }
        if (query == null) {
            parameters.put("query", "");
        } else {
            parameters.put("query", query);
        }
        if (ModelUtils.getNetUserThreshold(this.network) == null && this.user_threshold == null) {
            ModelUtils.setNetUserThreshold(this.network, 0.05);
        } else if (ModelUtils.getNetUserThreshold(this.network) != null && this.user_threshold == null) {
            ModelUtils.setNetUserThreshold(this.network, ModelUtils.getNetUserThreshold(this.network));
        } else {
            ModelUtils.setNetUserThreshold(this.network, Double.parseDouble(this.user_threshold));
        }
        if (ModelUtils.getNetNoIEA(this.network) == null && this.no_iea == null) {
            ModelUtils.setNetNoIEA(this.network, false);
        } else if (ModelUtils.getNetNoIEA(this.network) != null && this.no_iea == null) {
            ModelUtils.setNetNoIEA(this.network, ModelUtils.getNetNoIEA(this.network));
        } else {
            ModelUtils.setNetNoIEA(this.network, Boolean.parseBoolean(this.no_iea));
        }
        if (ModelUtils.getNetSignificanceThresholdMethod(this.network) == null && this.significance_threshold_method == null) {
            ModelUtils.setNetSignificanceThresholdMethod(this.network, "g_SCS");
        } else if (ModelUtils.getNetSignificanceThresholdMethod(this.network) != null && this.significance_threshold_method == null) {
            ModelUtils.setNetSignificanceThresholdMethod(this.network, ModelUtils.getNetSignificanceThresholdMethod(this.network));
        } else {
            ModelUtils.setNetSignificanceThresholdMethod(this.network, this.significance_threshold_method);
        }
        if (ModelUtils.getNetOrganism(this.network) == null) {
            ModelUtils.setNetOrganism(this.network, OrganismAndGeneIdAssertionTask.getOrganismPrediction());
        } else {
            ModelUtils.setNetOrganism(this.network, ModelUtils.getNetOrganism(this.network));
        }
        if (ModelUtils.getNetGeneIDColumn(this.network) == null) {
            ModelUtils.setNetGeneIDColumn(this.network, OrganismAndGeneIdAssertionTask.getGeneIdPrediction());
        } else {
            ModelUtils.setNetGeneIDColumn(this.network, ModelUtils.getNetGeneIDColumn(this.network));
        }
        return parameters;
    }

    public void cancel() {
        ScheduledRequestEngine.stopPostRequest();
        this.cancelled = true;
    }

    public Object getResults(Class type) {
        return this.res;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class, Long.class, CyTable.class);
    }
}

