/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.Palette;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;
import org.nrnb.gsoc.enrichment.model.ChartType;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentSettings;
import org.nrnb.gsoc.enrichment.tasks.ShowChartsTaskFactory;
import org.nrnb.gsoc.enrichment.utils.SessionUtils;

public class EnrichmentSettingsTask
extends AbstractTask {
    private CyServiceRegistrar registrar;
    private CyApplicationManager manager;
    private CyNetwork network;
    private final CyTable table;
    @ContainsTunables
    public EnrichmentSettings enrichmentSettings;

    public EnrichmentSettingsTask(CyServiceRegistrar registrar, CyApplicationManager manager, CyTable table) {
        this.network = manager.getCurrentNetwork();
        this.manager = manager;
        this.registrar = registrar;
        this.table = table;
        this.enrichmentSettings = new EnrichmentSettings(manager, registrar, this.network, table);
    }

    public void run(TaskMonitor arg0) {
        arg0.setTitle("Enrichment settings");
        SessionUtils.setTopTerms(this.network, this.table, (Integer)this.enrichmentSettings.nTerms.getValue());
        SessionUtils.setEnrichmentPalette(this.network, this.table, (Palette)this.enrichmentSettings.defaultEnrichmentPalette.getSelectedValue());
        SessionUtils.setChartType(this.network, this.table, (ChartType)((Object)this.enrichmentSettings.chartType.getSelectedValue()));
        TaskManager tm = (TaskManager)this.registrar.getService(TaskManager.class);
        tm.execute(new ShowChartsTaskFactory(this.registrar, this.manager).createTaskIterator());
    }

    @ProvidesTitle
    public String getTitle() {
        return "Network-specific settings for STRING Enrichment table";
    }
}

