/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteProviderManager;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.CyColorPaletteChooser;
import org.cytoscape.util.swing.CyColorPaletteChooserFactory;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.swing.util.UserAction;
import org.cytoscape.work.util.BoundedInteger;
import org.cytoscape.work.util.ListSingleSelection;
import org.nrnb.gsoc.enrichment.model.ChartType;
import org.nrnb.gsoc.enrichment.utils.SessionUtils;

public class EnrichmentSettings
implements ActionListener,
RequestsUIHelper {
    private final CyServiceRegistrar registrar;
    private final CyApplicationManager manager;
    private final CyNetwork network;
    private Component parent;
    private final CyTable enrichmentTable;
    @Tunable(description="Type of chart to draw", tooltip="Set the desired chart type", longDescription="Set the desired chart type", exampleStringValue="Split donut", groups={"Enrichment Defaults"}, gravity=100.0)
    public ListSingleSelection<ChartType> chartType;
    @Tunable(description="Number of terms to chart", tooltip="Set the default number of terms to use for charts", longDescription="Set the default number of terms to use for charts", exampleStringValue="5", groups={"Enrichment Defaults"}, gravity=101.0, params="slider=true")
    public BoundedInteger nTerms = new BoundedInteger(Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(8), false, false);
    @Tunable(description="Default Brewer palette for enrichment charts", longDescription="Set the default Brewer palette for enrichment charts", exampleStringValue="ColorBrewer Paired colors", groups={"Enrichment Defaults"}, gravity=102.0, context="nogui")
    public ListSingleSelection<Palette> defaultEnrichmentPalette;
    @Tunable(description="Change enrichment color palette", tooltip="Set the default Brewer color palette for enrichment charts", groups={"Enrichment Defaults"}, gravity=103.0, context="gui")
    public UserAction paletteChooserEnrichment = new UserAction((ActionListener)this);

    public EnrichmentSettings(CyApplicationManager manager, CyServiceRegistrar registrar, CyNetwork network, CyTable table) {
        this.manager = manager;
        this.network = network;
        this.registrar = registrar;
        this.enrichmentTable = table;
        PaletteProviderManager pm = (PaletteProviderManager)registrar.getService(PaletteProviderManager.class);
        List providers = pm.getPaletteProviders((PaletteType)BrewerType.QUALITATIVE, false);
        ArrayList<Palette> palettes = new ArrayList<Palette>();
        for (PaletteProvider provider : providers) {
            List paletteList = provider.listPaletteNames((PaletteType)BrewerType.QUALITATIVE, false);
            for (String id : paletteList) {
                palettes.add(provider.getPalette(id));
            }
        }
        this.defaultEnrichmentPalette = new ListSingleSelection(palettes);
        this.defaultEnrichmentPalette.setSelectedValue((Object)SessionUtils.getEnrichmentPalette(network, this.enrichmentTable));
        this.nTerms.setValue((Comparable)Integer.valueOf(SessionUtils.getTopTerms(network, this.enrichmentTable)));
        this.chartType = new ListSingleSelection((Object[])ChartType.values());
        this.chartType.setSelectedValue((Object)SessionUtils.getChartType(network, this.enrichmentTable));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CyColorPaletteChooser paletteChooser = ((CyColorPaletteChooserFactory)this.registrar.getService(CyColorPaletteChooserFactory.class)).getColorPaletteChooser((PaletteType)BrewerType.QUALITATIVE, true);
        Palette palette = paletteChooser.showDialog(this.parent, "Palette for Enrichment Colors", SessionUtils.getEnrichmentPalette(this.network, this.enrichmentTable), ((Integer)this.nTerms.getValue()).intValue());
        if (palette != null) {
            SessionUtils.setEnrichmentPalette(this.network, this.enrichmentTable, palette);
            this.defaultEnrichmentPalette.setSelectedValue((Object)palette);
        }
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.parent = helper.getParent();
    }
}

