/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.util.HashMap;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.BoundedDouble;
import org.nrnb.gsoc.enrichment.utils.CommandTaskUtil;
import org.nrnb.gsoc.enrichment.utils.SessionUtils;

public class EnrichmentMapAdvancedTask
extends AbstractTask
implements TaskObserver {
    private final CyTable filteredEnrichmentTable;
    private final CyNetwork network;
    private final CyTable unfilteredTable;
    private final CyServiceRegistrar registrar;
    private double defaultSimCutoff = 0.8;
    private CyTable customTable;
    private final String geneName = "gene name";
    private final String geneDescription = "gene description";
    @Tunable(description="Enrichment Map name")
    public String mapName = "Enrichment Map - String Network";
    @Tunable(description="Connectivity cutoff (Jaccard similarity)", longDescription="The cutoff for the lowest Jaccard similarity between terms.  Higher values mean more sparse connectivity while lower values mean more dense network cobnnectivity. ", tooltip="<html>The cutoff for the lowest Jaccard similarity of terms. <br /> Higher values mean more sparse connectivity while lower <br /> values mean more dense network cobnnectivity. <br /> </html>", params="slider=true")
    public BoundedDouble similarity = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(this.defaultSimCutoff), Double.valueOf(1.0), true, true);

    public EnrichmentMapAdvancedTask(CyNetwork network, CyTable filteredEnrichmentTable, CyTable originalEnrichmentTable, boolean filtered, CyServiceRegistrar registrar) {
        this.filteredEnrichmentTable = filteredEnrichmentTable;
        this.network = network;
        this.registrar = registrar;
        this.unfilteredTable = originalEnrichmentTable;
        if (filtered) {
            this.similarity.setBounds((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(SessionUtils.getRemoveRedundantCutoff(network, this.unfilteredTable)));
            this.similarity.setValue((Comparable)Double.valueOf(this.defaultSimCutoff * SessionUtils.getRemoveRedundantCutoff(network, this.unfilteredTable)));
        }
        String netName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        this.mapName = "Enrichment Map - " + netName;
    }

    public void run(TaskMonitor arg0) throws Exception {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("networkName", this.mapName);
        args.put("pvalueColumn", "p-value");
        args.put("genesColumn", "intersecting genes");
        args.put("nameColumn", "term name");
        args.put("table", "SUID:" + this.filteredEnrichmentTable.getSUID());
        args.put("coefficients", "JACCARD");
        args.put("similaritycutoff", String.valueOf(this.similarity.getValue()));
        args.put("pvalue", 0.05);
        args.put("descriptionColumn", "term name");
        CommandTaskUtil commandTaskUtil = new CommandTaskUtil(this.registrar);
        this.insertTasksAfterCurrentTask(commandTaskUtil.getCommandTaskIterator("enrichmentmap", "build-table", args, null));
    }

    @ProvidesTitle
    public String getTitle() {
        return "Create EnrichmentMap network";
    }

    public void taskFinished(ObservableTask task) {
    }

    public void allFinished(FinishStatus arg0) {
    }
}

