/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.ListSingleSelection;
import org.nrnb.gsoc.enrichment.model.EnrichmentTerm;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentTask;
import org.nrnb.gsoc.enrichment.tasks.OrganismAndGeneIdAssertionTask;
import org.nrnb.gsoc.enrichment.ui.EnrichmentCytoPanel;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;

public class EnrichmentAdvancedOptionsTask
extends AbstractTask
implements ObservableTask {
    final CyServiceRegistrar registrar;
    final CyApplicationManager applicationManager;
    final CyNetwork network;
    final CyTable nodeTable;
    private String displayValue;
    EnrichmentCytoPanel enrichmentPanel = null;
    public CyTable enrichmentTable;
    private static final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    @Tunable(description="Adjusted p-value threshold", tooltip="<html>Values above this threshold will be excluded.</html>", longDescription="A float value between 0 and 1, used to define a significance threshold for filtering returned results. Default value is 0.05.", exampleStringValue="0.05", groups={"Optional settings"}, params="slider=false", gravity=109.0)
    public BoundedDouble user_threshold = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(0.05), Double.valueOf(1.0), false, false);
    @Tunable(description="Include inferred GO annotations (IEA)", longDescription="The default (true) is to include inferred electronic annotations from Gene Ontology.", groups={"Optional settings"}, tooltip="<html>Uncheck to exclude inferred GO annotations.</html>")
    public boolean no_iea = false;
    @Tunable(description="Multiple testing correction", tooltip="Select the multiple testing correction method.", longDescription="The following multiple testing correction methods are supported: g_SCS (default), bonferroni and fdr.", exampleStringValue="g_SCS", groups={"Optional settings"}, gravity=100.0)
    public ListSingleSelection<String> significance_threshold_method;
    @Tunable(description="Organism", tooltip="The organism associated with the query genes.", longDescription="The organism associated with the query genes, e.g,. Homo sapiens.", exampleStringValue="Homo sapiens", params="lookup=begins", groups={"Required settings"}, gravity=10.0)
    public ListSingleSelection<String> organism;
    @Tunable(description="Gene ID Column", tooltip="<html>Select the <b>Node Table</b> column with the query genes.</html>", longDescription="The Node Table column containing the gene symbols or identifiers to be queried.", exampleStringValue="LABEL", params="lookup=begins", groups={"Required settings"}, gravity=10.0)
    public ListSingleSelection<String> geneID;
    public Map<String, String> scientificNametoID;

    public EnrichmentAdvancedOptionsTask(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.applicationManager = (CyApplicationManager)registrar.getService(CyApplicationManager.class);
        this.network = this.applicationManager.getCurrentNetwork();
        this.nodeTable = this.network.getDefaultNodeTable();
        this.setOrganism(this.network);
        ArrayList<String> stringCol = new ArrayList<String>();
        for (CyColumn col : this.nodeTable.getColumns()) {
            if (!col.getType().equals(String.class)) continue;
            stringCol.add(col.getName());
        }
        this.geneID = new ListSingleSelection(stringCol);
        if (ModelUtils.getNetGeneIDColumn(this.network) != null) {
            this.geneID.setSelectedValue((Object)ModelUtils.getNetGeneIDColumn(this.network));
        } else {
            this.geneID.setSelectedValue((Object)OrganismAndGeneIdAssertionTask.getGeneIdPrediction());
        }
        this.significance_threshold_method = new ListSingleSelection((List)new ArrayList<String>(){
            {
                this.add("g_SCS");
                this.add("bonferroni");
                this.add("fdr");
            }
        });
        this.significance_threshold_method.setSelectedValue((Object)"g_SCS");
        ModelUtils.setNetSignificanceThresholdMethod(this.network, "g_SCS");
        ModelUtils.setNetUserThreshold(this.network, 0.05);
    }

    public void run(TaskMonitor monitor) {
        CySwingApplication swingApplication = (CySwingApplication)this.registrar.getService(CySwingApplication.class);
        CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        this.enrichmentPanel = (EnrichmentCytoPanel)cytoPanel.getComponentAt(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
        TaskManager tm = (TaskManager)this.registrar.getService(TaskManager.class);
        if (this.network != null) {
            monitor.setTitle("Enrichment Advanced Options");
            if (!Objects.equals(ModelUtils.getNetOrganism(this.network), this.scientificNametoID.get(this.organism.getSelectedValue()))) {
                logger.info((Object)("[Enrichment Map] Selected new organism is: [" + this.scientificNametoID.get(this.organism.getSelectedValue()) + "]"));
            }
            if (!Objects.equals(ModelUtils.getNetGeneIDColumn(this.network), this.geneID.getSelectedValue())) {
                logger.info((Object)("[Enrichment Map] Selected new gene is: [" + (String)this.geneID.getSelectedValue() + "]"));
            }
            if (!Objects.equals(ModelUtils.getNetUserThreshold(this.network), this.user_threshold.getValue())) {
                logger.info((Object)("[Enrichment Map] Selected new user threshold is: [" + this.user_threshold.getValue() + "]"));
            }
            if (!Objects.equals(ModelUtils.getNetNoIEA(this.network), this.no_iea)) {
                logger.info((Object)("[Enrichment Map] Selected new IEA is: [" + this.no_iea + "]"));
            }
            if (!Objects.equals(ModelUtils.getNetSignificanceThresholdMethod(this.network), this.significance_threshold_method.getSelectedValue())) {
                logger.info((Object)("[Enrichment Map] Selected new significance threshold is: [" + (String)this.significance_threshold_method.getSelectedValue() + "]"));
            }
            ModelUtils.setNetSignificanceThresholdMethod(this.network, (String)this.significance_threshold_method.getSelectedValue());
            ModelUtils.setNetGeneIDColumn(this.network, (String)this.geneID.getSelectedValue());
            ModelUtils.setNetNoIEA(this.network, this.no_iea);
            ModelUtils.setNetUserThreshold(this.network, (Double)this.user_threshold.getValue());
            if (this.scientificNametoID.containsKey(this.organism.getSelectedValue())) {
                System.out.println("Organism selected value: " + (String)this.organism.getSelectedValue());
                ModelUtils.setNetOrganism(this.network, this.scientificNametoID.get(this.organism.getSelectedValue()));
                tm.execute(new TaskIterator(new Task[]{new EnrichmentTask(this.registrar, this.enrichmentPanel)}));
            } else {
                monitor.setStatusMessage("Could not find organism. Please select one of the supported organisms.");
            }
            this.enrichmentTable = ModelUtils.getEnrichmentTable(this.registrar, this.network, EnrichmentTerm.TermSource.ALL.getTable());
        }
    }

    private void setOrganism(CyNetwork network) {
        this.scientificNametoID = ModelUtils.getOrganisms();
        ArrayList<String> speciesList = new ArrayList<String>();
        String currentOrganism = ModelUtils.getNetOrganism(network) != null ? ModelUtils.getNetOrganism(network) : OrganismAndGeneIdAssertionTask.getOrganismPrediction();
        this.displayValue = currentOrganism;
        System.out.println("Display Value: " + this.displayValue);
        if (this.scientificNametoID != null) {
            for (Map.Entry<String, String> it : this.scientificNametoID.entrySet()) {
                speciesList.add(it.getKey());
                if (!it.getValue().equals(currentOrganism)) continue;
                this.displayValue = it.getKey();
            }
            Collections.sort(speciesList);
            this.organism = new ListSingleSelection(speciesList);
        }
        if (speciesList.contains(this.displayValue)) {
            this.organism.setSelectedValue((Object)this.displayValue);
        }
    }

    @ProvidesTitle
    public String getTitle() {
        return "Enrichment Settings";
    }

    public Object getResults(Class type) {
        return this.enrichmentTable.getSUID();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class, Long.class, CyTable.class);
    }
}

