/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class EnrichmentTerm
implements Comparable<EnrichmentTerm> {
    String name;
    String description;
    String source;
    Double pvalue;
    double goshv;
    boolean isSignificant;
    int effectiveDomainSize;
    int intersectionSize;
    int termSize;
    double precision;
    double recall;
    HashSet<String> evidenceCodes;
    String termID;
    List<String> genes;
    List<Long> nodes;
    public static final int nodeSUIDColumn = 13;
    public static final int chartColumnCol = 1;
    public static final String colSource = "source";
    public static final String colID = "id";
    public static final String colTermID = "term id";
    public static final String colName = "term name";
    public static final String colDescription = "description";
    public static final String colPvalue = "p-value";
    public static final String colGoshv = "goshv";
    public static final String colIsSignificant = "significant";
    public static final String colEffectiveDomainSize = "background size";
    public static final String colIntersectionSize = "intersection size";
    public static final String colTermSize = "term size";
    public static final String colQuerySize = "query size";
    public static final String colPrecision = "precision";
    public static final String colRecall = "recall";
    public static final String colGroupID = "group id";
    public static final String colGenes = "intersecting genes";
    public static final String colGenesSUID = "nodes.SUID";
    public static final String colNetworkSUID = "network.SUID";
    public static final String colGenesEvidenceCode = "Evidence codes";
    public static final String colChartColor = "chart color";
    public static final String colEnrichmentTermsNames = "enrichmentTermsNames";
    public static final String colEnrichmentTermsIntegers = "enrichmentTermsIntegers";
    public static final String colEnrichmentPassthrough = "enrichmentPassthrough";
    public static final String[] swingColumnsEnrichment = new String[]{"source", "chart color", "term id", "term name", "description", "p-value", "query size", "background size", "term size", "intersection size", "precision", "recall", "intersecting genes", "nodes.SUID", "Evidence codes"};
    public static final int nameColumn = 3;
    public static final int pvalueColumn = 5;
    int querySize;

    public EnrichmentTerm() {
        this.name = "";
        this.description = "";
        this.source = "";
        this.pvalue = 0.0;
        this.goshv = -1.0;
        this.isSignificant = true;
        this.effectiveDomainSize = 0;
        this.intersectionSize = 0;
        this.termSize = 0;
        this.precision = 0.0;
        this.recall = 0.0;
    }

    public EnrichmentTerm(String enrichmentSource) {
        this.name = "";
        this.description = "";
        this.source = enrichmentSource;
        this.pvalue = 0.0;
    }

    public <T> EnrichmentTerm(String name, String description, String source, double precision) {
        this.name = name;
        this.description = description;
        this.source = source;
        this.pvalue = precision;
        this.genes = new ArrayList<String>();
        this.nodes = new ArrayList<Long>();
    }

    public int getQuerySize() {
        return this.querySize;
    }

    public void setQuerySize(int querySize) {
        this.querySize = querySize;
    }

    public String getTermID() {
        return this.termID;
    }

    public void setTermID(String termID) {
        this.termID = termID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public double getPValue() {
        return this.pvalue;
    }

    public void setPValue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getGoshv() {
        return this.goshv;
    }

    public void setGoshv(double goshv) {
        this.goshv = goshv;
    }

    public boolean isSignificant() {
        return this.isSignificant;
    }

    public void setSignificant(boolean significant) {
        this.isSignificant = significant;
    }

    public int getEffectiveDomainSize() {
        return this.effectiveDomainSize;
    }

    public void setEffectiveDomainSize(int effectiveDomainSize) {
        this.effectiveDomainSize = effectiveDomainSize;
    }

    public int getIntersectionSize() {
        return this.intersectionSize;
    }

    public void setIntersectionSize(int intersectionSize) {
        this.intersectionSize = intersectionSize;
    }

    public int getTermSize() {
        return this.termSize;
    }

    public void setTermSize(int termSize) {
        this.termSize = termSize;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public void setRecall(double recall) {
        this.recall = recall;
    }

    public void setGenes(List<String> genes) {
        this.genes = genes;
    }

    public List<String> getGenes() {
        return this.genes;
    }

    public void setNodesSUID(List<Long> nodes) {
        this.nodes = nodes;
    }

    public List<Long> getNodesSUID() {
        return this.nodes;
    }

    public String toString() {
        return this.name + "\t" + this.pvalue;
    }

    public List<String> getEvidenceCodes() {
        return new ArrayList<String>(this.evidenceCodes);
    }

    public void setEvidenceCodes(HashSet<String> evidenceCodes) {
        this.evidenceCodes = evidenceCodes;
    }

    @Override
    public int compareTo(EnrichmentTerm et) {
        return this.pvalue.compareTo(et.getPValue());
    }

    public static enum TermSource {
        ALL("All", "All", "Enrichment: All"),
        ALLFILTERED("AllFilt", "All Filtered", "Enrichment: All Filtered"),
        GOPROCESS("Process", "Gene Ontology Biological Process", "Enrichment: GO Biological Process"),
        GOCOMPONENT("Component", "Gene Ontology Cellular Component branch", "Enrichment: GO Cellular Component"),
        GOFUNCTION("Function", "Gene Ontology Molecular Function", "Enrichment: GO Molecular Function"),
        KEGG("KEGG", "KEGG", "Enrichment: KEGG Pathways"),
        REACTOME("RCTM", "Reactome pathways", "Enrichment: Reactome Pathways"),
        WIKIPATHWAYS("WikiPathways", "WikiPathways", "Enrichment: WikiPathways"),
        TF("TF", "Transfac transcription factor binding site predictions", "Enrichment: TF"),
        MIRNA("MIRNA", "mirTarBase miRNA targets", "MIRNA"),
        HPA("HPA", "Human Protein Atlas", "Enrichment: HPA"),
        CORUM("CORUM", " Manually annotated protein complexes from mammalian organisms", "CORUM"),
        HP("HP", "Human Phenotype Ontology", "Enrichment: Human Phenotype Ontology");

        String key;
        String name;
        String table;

        private TermSource(String key, String name, String table) {
            this.key = key;
            this.name = name;
            this.table = table;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getTable() {
            return this.table;
        }

        public String toString() {
            return this.name;
        }

        public static List<String> getCategories() {
            ArrayList<String> cats = new ArrayList<String>();
            for (TermSource ts : TermSource.values()) {
                cats.add(ts.getKey());
            }
            return cats;
        }

        public static List<TermSource> getValues() {
            ArrayList<TermSource> cats = new ArrayList<TermSource>();
            for (TermSource ts : TermSource.values()) {
                if (ts == ALL || ts == ALLFILTERED) continue;
                cats.add(ts);
            }
            return cats;
        }

        public static List<String> getTables() {
            ArrayList<String> tables = new ArrayList<String>();
            for (TermSource ts : TermSource.values()) {
                tables.add(ts.getTable());
            }
            return tables;
        }

        public static boolean containsKey(String key) {
            for (TermSource ts : TermSource.values()) {
                if (!ts.getKey().equals(key)) continue;
                return true;
            }
            return false;
        }

        public static String getName(String key) {
            for (TermSource ts : TermSource.values()) {
                if (!ts.getKey().equals(key)) continue;
                return ts.getName();
            }
            return null;
        }

        public static TermSource getByKey(String key) {
            for (TermSource ts : TermSource.values()) {
                if (!ts.getKey().equals(key)) continue;
                return ts;
            }
            return null;
        }
    }
}

