/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.actions;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Properties;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.SelectedNodesAndEdgesListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.nrnb.gsoc.enrichment.tasks.EnrichmentTask;
import org.nrnb.gsoc.enrichment.ui.EnrichmentCytoPanel;
import org.nrnb.gsoc.enrichment.utils.IconUtil;

public class ShowAppTableAction
extends AbstractCyAction {
    private final CyServiceRegistrar serviceRegistrar;
    private static final String DESCRIPTION = "Results are displayed in the Enrichment Table using default organism and gene ID column.";
    CytoPanelComponent2 enrichmentPanel;

    public ShowAppTableAction(CyServiceRegistrar serviceRegistrar) {
        super("Enrichment Table");
        this.serviceRegistrar = serviceRegistrar;
        this.inToolBar = true;
        this.insertToolbarSeparatorBefore = true;
        this.toolbarGravity = 11.0f;
        Font iconFont = IconUtil.getIconFont(30.0f);
        TextIcon icon = new TextIcon(IconUtil.APP_ICON_LAYERS, iconFont, IconUtil.APP_ICON_COLORS, 32, 32, new Integer[]{1});
        this.putValue("ShortDescription", "Perform Gene Enrichment");
        this.putValue("LongDescription", DESCRIPTION);
        this.putValue("SwingLargeIconKey", icon);
    }

    public void actionPerformed(ActionEvent e) {
        CySwingApplication swingApplication = (CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class);
        CytoPanel cytoPanel = swingApplication.getCytoPanel(CytoPanelName.SOUTH);
        TaskManager tm = (TaskManager)this.serviceRegistrar.getService(TaskManager.class);
        if (this.enrichmentPanel == null) {
            this.enrichmentPanel = new EnrichmentCytoPanel(this.serviceRegistrar, false, null);
            this.serviceRegistrar.registerService((Object)this.enrichmentPanel, CytoPanelComponent.class, new Properties());
            this.serviceRegistrar.registerService((Object)this.enrichmentPanel, SelectedNodesAndEdgesListener.class, new Properties());
            this.serviceRegistrar.registerService((Object)this.enrichmentPanel, NetworkAboutToBeDestroyedListener.class, new Properties());
            this.serviceRegistrar.registerService((Object)this.enrichmentPanel, SessionLoadedListener.class, new Properties());
            this.serviceRegistrar.registerService((Object)this.enrichmentPanel, SetCurrentNetworkListener.class, new Properties());
            if (cytoPanel.getState() == CytoPanelState.HIDE) {
                cytoPanel.setState(CytoPanelState.DOCK);
            }
            cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
        } else {
            if (cytoPanel.getState() == CytoPanelState.HIDE) {
                cytoPanel.setState(CytoPanelState.DOCK);
            }
            cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
        }
        try {
            tm.execute(new TaskIterator(new Task[]{new EnrichmentTask(this.serviceRegistrar, this.enrichmentPanel)}));
        }
        catch (Exception ex) {
            System.err.println("Error executing EnrichmentTask: " + ex.getMessage());
        }
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent("org.nrnb.gsoc.enrichment"));
    }
}

