/*
 * Decompiled with CFR 0.152.
 */
package org.nrnb.gsoc.enrichment.RequestEngine;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nrnb.gsoc.enrichment.RequestEngine.ScheduledRequestEngine;
import org.nrnb.gsoc.enrichment.utils.ModelUtils;

public class HTTPRequestEngine {
    private final String basicURL = "https://biit.cs.ut.ee/gprofiler/api/";
    private final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public JSONObject makePostRequest(CyNetwork network, String endpoint, Map<String, Object> parameters, TaskMonitor monitor, boolean isBackgroundNeeded) {
        if (ModelUtils.getNetUserThreshold(network) != null) {
            parameters.put("user_threshold", ModelUtils.getNetUserThreshold(network));
        }
        if (ModelUtils.getNetAllResults(network) != null) {
            parameters.put("all_results", ModelUtils.getNetAllResults(network));
        }
        if (ModelUtils.getNetNoIEA(network) != null) {
            parameters.put("no_iea", ModelUtils.getNetNoIEA(network));
        } else {
            parameters.put("no_iea", true);
        }
        if (ModelUtils.getNetSignificanceThresholdMethod(network) != null) {
            parameters.put("significance_threshold_method", ModelUtils.getNetSignificanceThresholdMethod(network));
        } else {
            parameters.put("significance_threshold_method", "g_SCS");
        }
        StringBuffer backgroundNodes = new StringBuffer("");
        if (isBackgroundNeeded) {
            List nodeList = network.getNodeList();
            HashSet<String> nodeNameList = new HashSet<String>();
            for (CyNode node : nodeList) {
                String canonicalName = ModelUtils.getNetGeneIDColumn(network) == null ? (String)network.getDefaultNodeTable().getRow((Object)node.getSUID()).get("name", String.class) : (String)network.getDefaultNodeTable().getRow((Object)node.getSUID()).get(ModelUtils.getNetGeneIDColumn(network), String.class);
                if (canonicalName == null || canonicalName.length() <= 0 || canonicalName.contains(" ")) continue;
                nodeNameList.add(canonicalName);
            }
            Iterator setIterator = nodeNameList.iterator();
            while (setIterator.hasNext()) {
                backgroundNodes.append((String)setIterator.next());
                if (!setIterator.hasNext()) continue;
                backgroundNodes.append(" ");
            }
        }
        if (!backgroundNodes.toString().isEmpty()) {
            parameters.put("background", backgroundNodes.toString());
        }
        if (backgroundNodes.toString().isEmpty()) {
            parameters.put("domain_scope", "annotated");
        } else {
            parameters.put("domain_scope", "custom_annotated");
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        StringBuffer urlConverter = new StringBuffer();
        urlConverter.append(this.basicURL);
        urlConverter.append(endpoint);
        String url = urlConverter.toString();
        HttpPost httpPost = new HttpPost(url);
        String jsonBody = JSONValue.toJSONString(parameters);
        StringEntity entity = null;
        try {
            entity = new StringEntity(jsonBody);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            monitor.setStatusMessage("Could not fetch data. Check your internet connection");
            this.logger.error((Object)"Error creating StringEntity");
        }
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        CloseableHttpResponse response = null;
        try {
            response = ScheduledRequestEngine.sendPostRequestWithTimeLimit(httpclient, httpPost, 20L);
        }
        catch (IOException e) {
            e.printStackTrace();
            monitor.setStatusMessage("Could not fetch data. Check your internet connection");
            this.logger.error((Object)"Error sending post request.");
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            monitor.setStatusMessage("Task Cancelled. Returning back");
            this.logger.warn((Object)"Task Cancelled. Returning Back.");
            return null;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 202) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Got " + response.getStatusLine().getStatusCode() + " code from server");
            monitor.setStatusMessage("Invalid Query Parameters");
            this.logger.warn((Object)"Query parameters incorrect.");
            return null;
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(response.getEntity().getContent()));
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            monitor.setStatusMessage("Could not fetch data. Check your internet connection");
            this.logger.error((Object)"Error connecting to GProfiler");
        }
        this.logger.info((Object)"GProfiler Response received successfully");
        return jsonResponse;
    }
}

